<?php

namespace Studio148\ProlesApi\Contracts;

use App\Models\User;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Support\Collection;
use Studio148\ProlesApi\Exceptions\ProlesApiExceptionHandler;

interface ProlesApiContract
{
    public function up(): bool;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function getSingleSignOnURL(string $username, string $hash): string;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function authenticate(string $username, string $password): mixed;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function authenticateUsingHashedPassword(string $username, string $password): mixed;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function getResetPasswordTemporaryPassword(string $username): string;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function resetPassword($username, $token, $password): object|string;

    /** Get all contact and related data for parents
     * @throws ProlesApiExceptionHandler
     */
    public function getContact(string $email, string $hash): mixed;

    /** Get all contact data for parents
     * @throws ProlesApiExceptionHandler
     */
    public function getContactForParent(string $email, string $hash): mixed;

    /** Get all children for parents
     * @throws ProlesApiExceptionHandler
     */
    public function getChildren(string $email, string $hash): mixed;

    /** Get all invoices for parents
     * @throws ProlesApiExceptionHandler
     */
    public function getInvoicesForParent(string $email, string $hash): mixed;

    /** Get all financial data for parents
     * @throws ProlesApiExceptionHandler
     */
    public function getFinancialDataForParent(string $email, string $hash): mixed;

    /** Update parent contact data
     * @throws ProlesApiExceptionHandler
     */
    public function updateContact(string $email, string $hash, array $parameters): \stdClass;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function getParentInvoiceData(): Collection;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function notifySentParentInvoices(string $invoices): \StdClass;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function addChildToFamily(Authenticatable $user, array $child, string $hash): \stdClass;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function updateChild($email, $hash, $kindId, $kindgegevens): \StdClass|array;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function updatePaymentInfo(Authenticatable $user, string $hash): \stdClass;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function getStructureleOpvangDagenForChild(string $email, string $hash, int $kindId): array;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function updateStructureleOpvangDagenForChild($email, $hash, $kindId, $startDate, $newContractDays): array;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function getPresenceForChild(string $email, string $hash, int $kindId): \stdClass;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function updatePresenceForChild($email, $hash, $kindId, $datum): \stdClass;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function getExtraDataForCoordinator(string $email, string $hash): mixed;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function getExtraDataForOverblijfmedewerker(string $email, string $hash): mixed;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function getOverblijfmedewerkerVergoedingen(string $username, string $hash): array;

    /** Previously named getSchools
     * @throws ProlesApiExceptionHandler
     */
    public function getSchoolsFromProlesApi(): mixed;

    /** Previously named getUsers
     * @throws ProlesApiExceptionHandler
     */
    public function getUsersFromProlesApi(): Collection;
}