<?php

declare(strict_types=1);

namespace Studio148\ProlesApi\Exceptions;

use GuzzleHttp\Psr7\Response;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;

class ProlesApiExceptionHandler extends CustomExceptionHandler
{
    public static function IncorrectMD5HashException(Response $response): ProlesApiExceptionHandler
    {
        return new self('De API gebruikt een onjuiste md5 hash!', 400);
    }

    public static function ServerErrorException($response): ProlesApiExceptionHandler
    {
        $date_time = date_create();
        Storage::put("server_exception_{$date_time->format('Y-m-d-m-Y-H-i-s')}.idk", "$response");

        return new self('Er heeft een server error plaats gevonden!', 500);
    }

    public static function EmptyProlesHashResponse(Response $response): ProlesApiExceptionHandler
    {
        Log::critical("Client error occured! {$response}");

        return new self('De proles hash response is leeg, vermoedelijk is de gebruiker onbekend', 400);
    }
}
