<?php

namespace Studio148\ProlesApi\Contracts;

use App\User;
use Illuminate\Support\Collection;
use Studio148\ProlesApi\Exceptions\ProlesApiExceptionHandler;

interface ProlesApiContract
{
    /**
     * @throws ProlesApiExceptionHandler
     */
    public function authenticate(string $username, string $password): mixed;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function authenticateUsingHashedPassword($username, $password): mixed

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function getResetPasswordTemporaryPassword(string $username): string;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function resetPassword($username, $token, $password): object|string;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function getContact(string $email, string $hash): mixed;

    /** Previously named getSchools
     * @throws ProlesApiExceptionHandler
     */
    public function getSchoolsFromProlesApi(): mixed;

    /** Previously named getUsers
     * @throws ProlesApiExceptionHandler
     */
    public function getUsersFromProlesApi(): Collection;
}