<?php

namespace Studio148\ProlesApi\Contracts;

use Illuminate\Support\Collection;
use Studio148\ProlesApi\Exceptions\ProlesApiExceptionHandler;

interface ProlesApiContract
{
    /**
     * @throws ProlesApiExceptionHandler
     */
    public function authenticate(string $username, string $password): mixed;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function getContact(string $email, string $hash): mixed;

    /** Previously named getSchools
     * @throws ProlesApiExceptionHandler
     */
    public function getSchoolsFromProlesApi(): mixed;

    /** Previously named getUsers
     * @throws ProlesApiExceptionHandler
     */
    public function getUsersFromProlesApi(): Collection;
}