<?php

namespace Studio148\ProlesApi\Contracts;

use App\User;
use Illuminate\Support\Collection;
use Studio148\ProlesApi\Exceptions\ProlesApiExceptionHandler;

interface ProlesApiContract
{
    /**
     * @throws ProlesApiExceptionHandler
     */
    public function authenticate(string $username, string $password): mixed;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function authenticateUsingHashedPassword(string $username, string $password): mixed;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function getResetPasswordTemporaryPassword(string $username): string;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function resetPassword($username, $token, $password): object|string;

    /** Get all contact and related data for parents
     * @throws ProlesApiExceptionHandler
     */
    public function getContact(string $email, string $hash): mixed;

    /** Update parent contact data
     * @throws ProlesApiExceptionHandler
     */
    public function updateContact(string $email, string $hash, array $parameters): array;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function getExtraDataForCoordinator(string $email, string $hash): mixed;

    /**
     * @throws ProlesApiExceptionHandler
     */
    public function getExtraDataForOverblijfmedewerker(string $email, string $hash): mixed;

    /** Previously named getSchools
     * @throws ProlesApiExceptionHandler
     */
    public function getSchoolsFromProlesApi(): mixed;

    /** Previously named getUsers
     * @throws ProlesApiExceptionHandler
     */
    public function getUsersFromProlesApi(): Collection;
}