<?php

declare(strict_types=1);

namespace Studio148\ProlesApi;

use Illuminate\Support\ServiceProvider;

class ProlesApiServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        $this->app->singleton('proles-api', function () {
            return new ProlesApi;
        });
    }

    /**
     * Bootstrap any package services.
     */
    public function boot(): void
    {
        $this->publishes([
            __DIR__.'/../config/proles-api.php' => config_path('proles-api.php'),
        ]);
    }
}
